using UnityEngine;

namespace hiveAdiz
{
	public class PrivacySettings {

		public bool isTagForUnderAgeOfConsent = false;
		public bool isTagForChildDirectedTreatment = false;

		public PrivacySettings(bool isUnderAgeForGDPR, bool isChildDirectedTreatmentForCOPPA) {
			this.isTagForUnderAgeOfConsent = isUnderAgeForGDPR;
			this.isTagForChildDirectedTreatment = isChildDirectedTreatmentForCOPPA;
		}

		public class Builder {

			private bool isTagForUnderAgeOfConsent = false;
			private bool isTagForChildDirectedTreatment = false;
		
			public Builder() { }
			
			public Builder SetTagForUnderAgeOfConsent(bool isConsent) {
				isTagForUnderAgeOfConsent = isConsent;
				return this;
			}

			public Builder SetTagForChildDirectedTreatment(bool isConsent) {
				isTagForChildDirectedTreatment = isConsent;
				return this;
			}

			public PrivacySettings Build() {
				return new PrivacySettings(isTagForUnderAgeOfConsent, isTagForChildDirectedTreatment);
			}
		}
	}
}